package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestRole extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		
		// test that the reference values in the Role class are in sync with what the database should contain
		
		Role.initialize();
		
		Role r = Role.findById(1);
		Assert.assertNotNull(r);
		Assert.assertEquals(r.getId(), 1);
		Assert.assertEquals(r, Role.REVIEWER);
		Assert.assertEquals(r.getName(), "reviewer");

		Role a = Role.findById(2);
		Assert.assertNotNull(a);
		Assert.assertEquals(a.getId(), 2);
		Assert.assertEquals(a, Role.ADMINISTRATOR);
		Assert.assertEquals(a.getName(), "admin");

		Role s = Role.findById(3);
		Assert.assertNotNull(s);
		Assert.assertEquals(s.getId(), 3);
		Assert.assertEquals(s, Role.SUPER_USER);
		Assert.assertEquals(s.getName(), "superuser");

		Role n = Role.findById(4);
		Assert.assertNotNull(n);
		Assert.assertEquals(n.getId(), 4);
		Assert.assertEquals(n, Role.NDS_ADMIN);
		Assert.assertEquals(n.getName(), "irma");
	}
	
	@Test
	public void testTwo() throws Exception {

		try {
			Role.findById(0);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		List<Role> roleList = Role.listAll();
		 
		Assert.assertNotNull(roleList);
		Assert.assertTrue(roleList.size() > 0);
		 
	}

	@Test
	public void testThree() throws Exception {

		try {
			Role.findById(-1);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}

		
		// find somebody to search for
		List<Role> roleList = Role.listAll();
		 
		Assert.assertNotNull(roleList);
		Assert.assertTrue(roleList.size() > 0);

		Role role1 = roleList.get(0);
		Assert.assertNotNull(role1);
		Assert.assertTrue(role1.getId() > 0);
		
		Role role2 = Role.findById(role1.getId());
		Assert.assertNotNull(role2);
		Assert.assertEquals(role2, role1);
	}

}
